/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketVehicleServerMovement
extends APacketEntity<EntityVehicleF_Physics> {
    private final Point3D motion;
    private final Point3D rotation;
    private final double pathing;

    public PacketVehicleServerMovement(EntityVehicleF_Physics vehicle, Point3D motion, Point3D rotation, double pathing) {
        super(vehicle);
        this.motion = motion;
        this.rotation = rotation;
        this.pathing = pathing;
    }

    public PacketVehicleServerMovement(ByteBuf buf) {
        super(buf);
        this.motion = PacketVehicleServerMovement.readPoint3dFromBuffer(buf);
        this.rotation = PacketVehicleServerMovement.readPoint3dFromBuffer(buf);
        this.pathing = buf.readDouble();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketVehicleServerMovement.writePoint3dToBuffer(this.motion, buf);
        PacketVehicleServerMovement.writePoint3dToBuffer(this.rotation, buf);
        buf.writeDouble(this.pathing);
    }

    @Override
    public boolean handle(AWrapperWorld world, EntityVehicleF_Physics vehicle) {
        vehicle.addToServerDeltas(this.motion, this.rotation, this.pathing);
        return false;
    }
}

